package net.w_horse.excelpojo.xml;

import net.w_horse.excelpojo.excel.cellseeker.MappedCellSeeker;
import net.w_horse.excelpojo.xml.tag.DataDirection;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class MappedCellSeekerFactoryBean extends AbstractCellSeekerFactoryBean {

	private String previousLabel;
	private String position;
	private String retrieveFrom;
	private String terminate;
	private String margedLabel;
	private String dataDirection = DataDirection.RIGHT.getValue();

	@Override
	BeanDefinitionBuilder parse(Element element,
			CellSeekerFactoryBeanAcceptableXMLParser parser,
			ParserContext parserContext) {
		return parser.parse(element, this, parserContext);
	}

	@Override
	public Object getObject() throws Exception {
		MappedCellSeeker seeker = new MappedCellSeeker();
		seeker.setPreviousLabel(getPreviousLabel());
		seeker.setPosition(getPosition());
		seeker.setRetrieveFrom(getRetrieveFrom());
		seeker.setDataDirection(getDataDirection());
		seeker.setMargedLabel(getMargedLabel());
		seeker.setUse(getUse());
		seeker.setRange(getRange());

		return seeker;
	}

	@Override
	public Class<MappedCellSeeker> getObjectType() {
		return MappedCellSeeker.class;
	}

	public void setPreviousLabel(String previousLabel) {
		this.previousLabel = previousLabel;
	}
	public String getPreviousLabel() {
		return previousLabel;
	}
	public void setPosition(String position) {
		this.position = position;
	}
	public String getPosition() {
		return position;
	}
	public void setRetrieveFrom(String retrieveFrom) {
		this.retrieveFrom = retrieveFrom;
	}
	public String getRetrieveFrom() {
		return retrieveFrom;
	}
	public void setTerminate(String terminate) {
		this.terminate = terminate;
	}
	public String getTerminate() {
		return terminate;
	}
	public void setMargedLabel(String margedLabel) {
		this.margedLabel = margedLabel;
	}
	public String getMargedLabel() {
		return margedLabel;
	}
	public void setDataDirection(String dataDirection) {
		this.dataDirection = dataDirection;
	}
	public String getDataDirection() {
		return dataDirection;
	}
}
